#########################################################################
#	file: 		example1.t					#
#	description:	an example that opens a MS Access DB and	#
#			populates the tables with the invoice data	#
#	date:		250203						#
#	modified:	250203						#
#	Written By:	Mads Linden					#
#	(C) Copyright 1999 by The Electronic Farm Sweden.					#
#	(C) Copyright 2007 by Farmers Wife S.L..							#
#	version:	0.1 (wife 40,0,1)				#
#########################################################################

# NOTE:
# you must add a DSN to the example file in the scripts/invoice_module/example2.mdb and call the dsn EXAMPLE2, or edit below


# load graphical toolkit for tcl = tk
if {$::PLATFORM == 3} {
	package require ::External::Tk
} else {
	catch {package require Tk}
}

# set the name of our little window that just came up
wm title . "Invoice Example Script 2"

# make a text widget where we can show info about the transfer, and a "quit" button below
text .t -width 100 -height 30
button .b -text "Quit" -command "wife::send exit $SESSION"
pack .t .b -fill both -expand 1


# load the tclodbc extension that allows us the com. with mdb's , dsn's etc...
# see http://megamail.solagem.fi/~rnurmi/reference.html for details
if {$tcl_platform(platform) == "windows"} {
	# pc
	.t insert end "Loading Tclodbc.dll\n"
	update
	if {[catch {
		load $WIFE_HOME/lib/tclodbc.dll
	} result]} {
		.t insert end "Error On Tclodbc:\n$result\n"
		return
	}
} else {
	# mac
	# LATER!!
	.t insert end "Example Not Done For Mac Yet, sorry\n"
	return
}

# connect to the DSN
if {[catch {
	database db "EXAMPLE2"
} result]} {
	.t insert end "Error On Connection To The Odbc:\n$result\n"
	return
}

# clear all old data in the DB to make to example clean and avoid double keys
db "DELETE FROM invoices"
db "DELETE FROM elements"


# now since there is a "wakeup" variable created we just loop on it
# it holds all the user selected invoices as tcl lists
# see readme.txt for details about what values in the tcl lists we are looping on
# also when populating we are using some check procs defined in include/sql.t
foreach invoice $INVOICES_SELECTED {
	
	###################################
	# first in this loop we populate the table "invoices" that holds:
	# 1. invoice_number
	# 2. invoice_name
	# 3. invoice_created
	# 4. invoice_due
	# 5. client_id
	# 6. client_name
	# 7. client_contact
	
	
	# we build two list we can fire into the db
	set columns ""
	set values ""
	
	# 1. add invoice_number
	lappend columns "invoice_number"
	lappend values "'[sql:check_value [lindex $invoice 2] VARCHAR 255]'"
	
	# 2. add invoice_name
	lappend columns "invoice_name"
	lappend values "'[sql:check_value [lindex $invoice 1] VARCHAR 255]'"
	
	# 3. add invoice_created
	lappend columns "invoice_created"
	lappend values "'[sql:check_datetime [lindex $invoice 0]]'"
	
	# 4. add invoice_due
	# since the value is in wife intday format we use wife to get a real id out of it, since id we can convert to sql dates
	set tmp [lindex [wife::send intday_to_id [lindex $invoice 23]] 1]
	lappend columns "invoice_due"
	lappend values "'[sql:check_datetime $tmp]'"
	unset tmp
	
	# 5. add client_id, we use i_company_number for this
	lappend columns "client_id"
	lappend values "'[sql:check_value [lindex $invoice 4] VARCHAR 255]'"
	
	# 6. add client_name, we use i_company_number for this
	lappend columns "client_name"
	lappend values "'[sql:check_value [lindex $invoice 7] VARCHAR 255]'"
	
	# 7. add client_contact, we use i_company_number for this
	lappend columns "client_contact"
	lappend values "'[sql:check_value [lindex $invoice 6] VARCHAR 255]'"
	
	# populate the table with it all
	db "INSERT INTO invoices ([join $columns ,]) VALUES ([join $values ,])"
	
	
	
	###################################
	# now we do a loop on all elements for the invoice (i_objects) , this table holds:
	# 1. invoice_number
	# 2. name
	# 3. ref
	# 4. amount
	# 5. discount
	# 6. unit_price
	foreach element [lindex $invoice 21] {
		
		
		# we build two list we can fire into the db
		set columns ""
		set values ""
		
		# 1. add invoice_number
		lappend columns "invoice_number"
		lappend values "'[sql:check_value [lindex $invoice 2] VARCHAR 255]'"
		
		# 2. add name
		lappend columns "name"
		lappend values "'[sql:check_value [lindex $element 8] VARCHAR 255]'"
		
		# 3. add ref
		lappend columns "ref"
		lappend values "'[sql:check_value [lindex $element 15] VARCHAR 255]'"
		
		# 4. add amount
		lappend columns "amount"
		lappend values "'[sql:check_double [lindex $element 10]]'"
		
		# 5. add discount
		lappend columns "discount"
		lappend values "'[sql:check_double [lindex $element 13]]'"
		
		# 6. add unit_price
		lappend columns "unit_price"
		lappend values "'[sql:check_rate [lindex $element 12]]'"
		
		# populate the table with it all
		db "INSERT INTO elements ([join $columns ,]) VALUES ([join $values ,])"
		
	}
	
	
	# print out that we did the transfer
	.t insert end "Transfered [lindex $invoice 2] / [lindex $invoice 1]\n"
	update
}

# disconnect from the dsn
db disconnect 

.t insert end "Done\n"


